﻿<%@ Page Title="" Language="C#" MasterPageFile="~/TBI_Instruments/RegistryInstrument.master" AutoEventWireup="true" CodeFile="OswestryLBDQ.aspx.cs" Inherits="TBI_Instruments_OswestryLBDQ" %>

<%@ Import Namespace="VeteransAffairs.Registries.Business" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<%@ Register TagPrefix="VA" TagName="TbiDiagnosisSelector" Src="~/controls/TbiDiagnosisSelector.ascx" %>


<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
    <link type="text/css" href="~/styles/StyleSheet.css" />
    <style type="text/css">
        .breadcrumbInstrument
        {
            background-color: #6B1424;
            border-bottom: 1px solid #000;
            color: #FFF;
            font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;
            font-variant: small-caps;
            font-weight: 700;
            letter-spacing: 1px;
            margin: 2px 0 2px 0;
            padding: 8px 25px 5px 10px;
        }
        .detailTable
        {
            border: 0px;
            background-color: #FFFFFF;
        }
        .detailTable td
        {
            border: 0px;
            background-color: #FFFFFF;
        }
        .requiredField 
        {
        	font-weight:bold;
        	color:#FF0000;
        }
    </style>
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">
    <asp:ScriptManager ID="ScriptManager1" ScriptMode="Release" runat="server">
    </asp:ScriptManager>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock1">

        <script type="text/javascript">
            Sys.WebForms.PageRequestManager.getInstance().add_beginRequest(startRequest);
            Sys.WebForms.PageRequestManager.getInstance().add_endRequest(endRequest);

            function startRequest(sender, e) {
                //disable button during the AJAX call
                document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = true;
                document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = true;
                document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = true;
            }
            function endRequest(sender, e) {
                //re-enable button once the AJAX call has completed
                document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = false;
                document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = false;
                document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = false;
            }
        </script>
        <script type="text/javascript">
            $(document).ready(function() {

                // Disables 'Enter' Key from posting back on any input 
                // element ( textbox, radiolist, checkbox, etc )
                $('input').keydown(function(e) {
                    if (e.keyCode == 13) { return false; }
                });

                // Disables 'Enter' Key from posting back when no input 
                // element is in focus, and the enter key is pressed 
                $('div').keydown(function(e) {
                    if (e.keyCode == 13) { return false; }
                });

            }); // END $(document).ready(function()
        </script>
        <script type="text/javascript">
            $(document).ready(function () {
               $('input:text').keydown(function(e) {
                    //cancel enter to prevent errors
                    if (e.keyCode == 13)
                        return false;
                });

                //processPersonReporting_Click();
                //processRadioButtonQ_Click();

                window.onbeforeunload = function () {
                    //Save draft if timeout occurs
                    document.getElementById('<%= btnSaveSurveyDraft.ClientID %>').click();
                   // return;
                }

            }); // END $(document).ready(function()

        </script>

    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock2">
        <div class="breadcrumbInstrument">
            <asp:Label ID="LabelBreadCrumb" runat="server" Text="TBI Instruments > Instrument Associations > Oswestry Low Back Pain Disability Questionnaire (OLBPDQ)"></asp:Label>
        </div>
    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock3">
        <asp:UpdatePanel ID="MainUpdatePanel" runat="server">
            <ContentTemplate>
                <asp:UpdateProgress ID="MainUpdateProgress" runat="server">
                    <ProgressTemplate>
                        <!-- Modal Popup for Loading -->
                        <div style="padding-left: 3px;">
                            <div style="background-color: #FF0000; width: 170px; color: #FFFFFF; padding: 5px;">
                                Processing...Please wait.
                            </div>
                        </div>
                        <%--<div style="background-color: Gray; filter: alpha(opacity=50); opacity: 0.50; width: 100%; top: 0px; left: 0px; position: fixed;
                            height: 100%;">
                        </div>
                        <div style="margin: auto; font-family: Trebuchet MS; filter: alpha(opacity=100); opacity: 1; font-size: small; vertical-align: middle;
                            top: 45%; position: fixed; right: 45%; color: #232323; text-align: center; background-color: White; height: 100px;">
                            <table style="background-color: White; font-family: Sans-Serif; text-align: center; border: solid 1px #232323; color: #232323;
                                width: 300px; height: inherit; padding: 15px;">
                                <tr>
                                    <td style="text-align: inherit;">
                                        <img src="images/loading_image.gif" alt="Loading" title="Loading Image" />
                                    </td>
                                    <td style="text-align: inherit;">
                                        <span style="font-family: Sans-Serif; font-size: medium; font-weight: bold; font">Processing...Please wait.</span>
                                    </td>
                                </tr>
                            </table>
                        </div>--%>
                        <!-- End Modal Popup for Loading -->
                    </ProgressTemplate>
                </asp:UpdateProgress>
                <asp:ValidationSummary ID="TBIInstrumentsValidationSummaryOnSave" runat="server" TabIndex="1" HeaderText="The page has the following data errors:"
                    DisplayMode="BulletList" ShowSummary="false" ShowMessageBox="true" ValidationGroup="OnSave" />
                <asp:Panel ID="PanelPatient" Width="100%" GroupingText="&nbsp;&nbsp;Patient&nbsp;&nbsp;" runat="server">
                    <table cellpadding="5" cellspacing="5">
                        <tr>
                            <td>
                                &nbsp;&nbsp;<asp:Label ID="LabelForName" runat="server" Text="Patient:" AssociatedControlID="LabelPatient"></asp:Label>&nbsp;<asp:Label
                                    ID="LabelPatient" runat="server" SkinID="DataLabel" TabIndex="2"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForSSN" runat="server" SkinID="DataLabel" AssociatedControlID="LabelSSN" Text="SSN:"></asp:Label>
                                &nbsp;<asp:Label ID="LabelSSN" runat="server" SkinID="DataLabel" TabIndex="3"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForFacility" runat="server" SkinID="DataLabel" AssociatedControlID="LabelFacility" Text="Facility:" Visible="false"></asp:Label>
                                &nbsp;<asp:Label ID="LabelFacility" runat="server" SkinID="DataLabel" TabIndex="4"></asp:Label>
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
                <!-- Hidden Field - Survey Type -->
                <asp:HiddenField ID="HiddenSurveyType" runat="server" Visible="false" Value="OLBPDQ" />
                <asp:Panel ID="PanelSurveyHeader" Width="100%" runat="server" CssClass="mainContent">
                    <br />
                    <asp:Label ID="LabelInstrumentTitle" runat="server" Style="font-weight: bold" />&nbsp;-&nbsp;
                    <asp:LinkButton ID="lnkBtnToggleInstructions" runat="server" Text="Click for Instructions" ToolTip="Click to show/hide instructions."
                        OnClick="lnkBtnToggleInstructions_OnClick" TabIndex="5" />
                    <br />
                </asp:Panel>
                <!-- Instruction Area -->
                <asp:Panel ID="PanelInstructions" runat="server" Visible="false">
                    <br />
                    <div style="padding: 5px; width: 900px;">
                        
                        <h2>Scoring instructions</h2>
                        <table style="width:700px;">
                            <tr>
                                <td colspan="2">
                                    For each section the total possible score is 5: if the first statement is marked the section score = 0; if the last statement is marked, it = 5. If all 10 sections are completed the score is calculated as follows:
                                </td>
                            </tr>
                            <tr>
                                <td style="width:150px;">
                                    Example:
                                </td>
                                <td>
                                    16 (total scored)<br />
                                    50 (total possible score) x 100 = 32%
                                </td>
                            </tr>
                            <tr>
                                <td colspan="2">
                                    If one section is missed or not applicable the score is calculated:
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    &nbsp;
                                </td>
                                <td>
                                    16 (total scored)<br />
                                    45 (total possible score) x 100 = 35.5%
                                </td>
                            </tr>
                            <tr>
                                <td colspan="2">
                                    Minimum detectable change (90% confidence): 10% points (change of less than this may be attributable to error in the measurement)
                                </td>
                            </tr>
                        </table>
                        <br /><br />
                            
                        <h3>Interpretation of scores</h3>
                        <table style="width:700px; border: solid 1px navy;">
                            <tr>
                                <td style="width:250px; font-weight:bold;">
                                    0% to 20%: minimal disability:
                                </td>
                                <td>
                                    The patient can cope with most living activities. Usually no treatment is indicated apart from advice on lifting sitting and exercise.
                                </td>
                            </tr>
                            <tr>
                                <td style="font-weight:bold;">
                                    21%-40%: moderate disability:
                                </td>
                                <td>
                                    The patient experiences more pain and difficulty with sitting, lifting and standing. Travel and social life are more difficult and they may be disabled from work. Personal care, sexual activity and sleeping are not grossly affected and the patient can usually be managed by conservative means.
                                </td>
                            </tr>
                            <tr>
                                <td style="font-weight:bold;">
                                    41%-60%: severe disability:
                                </td>
                                <td>
                                    Pain remains the main problem in this group but activities of daily living are affected. These patients require a detailed investigation.
                                </td>
                            </tr>
                            <tr>
                                <td style="font-weight:bold;">
                                    41%-60%: severe disability:
                                </td>
                                <td>
                                    Back pain impinges on all aspects of the patient's life. Positive intervention is required.
                                </td>
                            </tr>
                            <tr>
                                <td style="font-weight:bold;">
                                    81%-100%:
                                </td>
                                <td>
                                    These patients are either bed-bound or exaggerating their symptoms.
                                </td>
                            </tr>
                        </table>
                    </div>
                </asp:Panel>
                <!-- End Instruction Area -->
                
                
                <asp:Panel ID="PanelQuestions" Width="100%" runat="server" CssClass="mainContent">
                    <br />
                    <!-- Question Area -->
                    <table style="width:100%;">
                        <tr>
                            <td style="width:25px"></td>
                            <td>
                                <!-- Diagnosis Control -->
                                <!-- Set Question Text, SurveyTypeId, SurveyTypeCode in the page_load -->
                                <VA:TbiDiagnosisSelector ID="ctrlDiagnosis" runat="server" QuestionNumber="DX" StartTabIndex="10" />
                            </td>
                        </tr>
                    </table>
                    <table style="width:350px">
                        <tr>
                            <td>
                                <asp:Label ID="LabelDate1" runat="server" AssociatedControlID="dpDate1" SkinID="DataLabel" TabIndex="20">
                                </asp:Label> <span class="requiredField">*</span>
                            </td>
                            <td>
                                <telerik:RadDatePicker ID="dpDate1" runat="server" TabIndex="21">
                                    <Calendar ID="calDate1" runat="server">
                                    </Calendar>
                                </telerik:RadDatePicker>
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorDate1" runat="server" ControlToValidate="dpDate1" TabIndex="22" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Date is required."></asp:RequiredFieldValidator>
                                <br />
                            </td>
                        </tr>
                        
                    </table>
                    
                    <table width="100%">

                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <asp:Label ID="LabelForQ1" runat="server" AssociatedControlID="rblQ1" SkinID="DataLabel" TabIndex="25"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 30px;">&nbsp;</td>
                            <td>
                                <asp:RadioButtonList ID="rblQ1" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ1" TabIndex="26"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" AutoPostBack="false">
                                </asp:RadioButtonList>

                                <asp:ObjectDataSource ID="ObjectDataSourceQ1" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ1" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ1" runat="server" Visible="false" Value="1" />
                            </td>
                        </tr>


                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <asp:Label ID="LabelForQ2" runat="server" AssociatedControlID="rblQ2" SkinID="DataLabel" TabIndex="30"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 30px;">&nbsp;</td>
                            <td>
                                <asp:RadioButtonList ID="rblQ2" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ2" TabIndex="31"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" AutoPostBack="false">
                                </asp:RadioButtonList>
                                
                                <asp:ObjectDataSource ID="ObjectDataSourceQ2" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ2" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ2" runat="server" Visible="false" Value="2" />
                            </td>
                        </tr>


                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <asp:Label ID="LabelForQ3" runat="server" AssociatedControlID="rblQ3" SkinID="DataLabel" TabIndex="40"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 30px;">&nbsp;</td>
                            <td>
                                <asp:RadioButtonList ID="rblQ3" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ3" TabIndex="41"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" AutoPostBack="false">
                                </asp:RadioButtonList>
                                
                                <asp:ObjectDataSource ID="ObjectDataSourceQ3" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ3" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ3" runat="server" Visible="false" Value="3" />
                            </td>
                        </tr>


                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <asp:Label ID="LabelForQ4" runat="server" AssociatedControlID="rblQ4" SkinID="DataLabel" TabIndex="45"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 30px;">&nbsp;</td>
                            <td>
                                <asp:RadioButtonList ID="rblQ4" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ4" TabIndex="46"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" AutoPostBack="false">
                                </asp:RadioButtonList>
                                
                                <asp:ObjectDataSource ID="ObjectDataSourceQ4" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ4" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ4" runat="server" Visible="false" Value="4" />
                            </td>
                        </tr>


                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <asp:Label ID="LabelForQ5" runat="server" AssociatedControlID="rblQ5" SkinID="DataLabel" TabIndex="50"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 30px;">&nbsp;</td>
                            <td>
                                <asp:RadioButtonList ID="rblQ5" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ5" TabIndex="51"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" AutoPostBack="false">
                                </asp:RadioButtonList>
                                
                                <asp:ObjectDataSource ID="ObjectDataSourceQ5" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ5" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ5" runat="server" Visible="false" Value="5" />
                            </td>
                        </tr>


                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <asp:Label ID="LabelForQ6" runat="server" AssociatedControlID="rblQ6" SkinID="DataLabel" TabIndex="55"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 30px;">&nbsp;</td>
                            <td>
                                <asp:RadioButtonList ID="rblQ6" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ6" TabIndex="56"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" AutoPostBack="false">
                                </asp:RadioButtonList>
                                
                                <asp:ObjectDataSource ID="ObjectDataSourceQ6" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ6" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ6" runat="server" Visible="false" Value="6" />
                            </td>
                        </tr>


                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <asp:Label ID="LabelForQ7" runat="server" AssociatedControlID="rblQ7" SkinID="DataLabel" TabIndex="60"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 30px;">&nbsp;</td>
                            <td>
                                <asp:RadioButtonList ID="rblQ7" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ7" TabIndex="61"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" AutoPostBack="false">
                                </asp:RadioButtonList>
                               
                                <asp:ObjectDataSource ID="ObjectDataSourceQ7" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ7" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ7" runat="server" Visible="false" Value="7" />
                            </td>
                        </tr>


                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <asp:Label ID="LabelForQ8" runat="server" AssociatedControlID="rblQ8" SkinID="DataLabel" TabIndex="65"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 30px;">&nbsp;</td>
                            <td>
                                <asp:RadioButtonList ID="rblQ8" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ8" TabIndex="66"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" AutoPostBack="false">
                                </asp:RadioButtonList>
                                
                                <asp:ObjectDataSource ID="ObjectDataSourceQ8" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ8" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ8" runat="server" Visible="false" Value="8" />
                            </td>
                        </tr>


                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <asp:Label ID="LabelForQ9" runat="server" AssociatedControlID="rblQ9" SkinID="DataLabel" TabIndex="70"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 30px;">&nbsp;</td>
                            <td>
                                <asp:RadioButtonList ID="rblQ9" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ9" TabIndex="71"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" AutoPostBack="false">
                                </asp:RadioButtonList>
                                
                                <asp:ObjectDataSource ID="ObjectDataSourceQ9" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ9" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ9" runat="server" Visible="false" Value="9" />
                            </td>
                        </tr>


                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <asp:Label ID="LabelForQ10" runat="server" AssociatedControlID="rblQ10" SkinID="DataLabel" TabIndex="75"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 30px;">&nbsp;</td>
                            <td>
                                <asp:RadioButtonList ID="rblQ10" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ10" TabIndex="76"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" AutoPostBack="false">
                                </asp:RadioButtonList>
                               
                                <asp:ObjectDataSource ID="ObjectDataSourceQ10" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ10" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ10" runat="server" Visible="false" Value="10" />
                            </td>
                        </tr>


                        
                        
                        
                        <tr>
                            <td colspan="100%">
                                <asp:Button ID="btnCalculate" runat="server" Text="Calculate" OnClick="btnCalculate_Click" TabIndex="80" />
                                <br /><br />
                            </td>
                        </tr>
                        
                        <tr>
                            <td colspan="100%">
                                <!--Question 11: Total Score -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ11" runat="server" SkinID="DataLabel" TabIndex="90"></asp:Label>:&nbsp;    
                                <asp:Label ID="lblTotalScore" runat="server" Font-Bold="true" Text="0" TabIndex="91"></asp:Label>
                            </td>
                        </tr>
    
                        <tr>
                            <td colspan="100%">
                                <!--Question 12: Total Possible Score -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ12" runat="server" SkinID="DataLabel" TabIndex="92"></asp:Label>:&nbsp;    
                                <asp:Label ID="lblTotalPossibleScore" runat="server" Font-Bold="true" Text="0" TabIndex="93"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <!--Question 13: Total Calculated Score -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ13" runat="server" SkinID="DataLabel" TabIndex="94"></asp:Label>:&nbsp;    
                                <asp:Label ID="lblTotalCalculatedScore" runat="server" Font-Bold="true" Text="0" TabIndex="95"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <asp:Label ID="lblSurveyError" runat="server" TabIndex="96" CssClass="requiredField"></asp:Label>
                            </td>
                        </tr> 
                    </table>
                    
                    
                    <!-- End Question Area -->
                    <br />
                </asp:Panel>                        
                        
                <telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server">
                    <asp:Timer ID="InactiveTimer" Interval="300000" Enabled="true" runat="server" OnTick="InActiveTimer_Tick" />
                </telerik:RadAjaxPanel>
                <asp:Button ID="btnSaveSurveyDraft" runat="server" UseSubmitBehavior="true" Text="Save Draft" Width="130px" OnClick="btnSaveSurveyDraft_Click"
                    ValidationGroup="OnSaveDraft" TabIndex="100" />
                <asp:Button ID="btnSubmitSurvey" runat="server" UseSubmitBehavior="true" Text="Save and Prepare Note" Width="180px" OnClick="btnSubmit_Click"
                    ValidationGroup="OnSave" TabIndex="101" />
                <asp:Button ID="btnCancelSurvey" runat="server" TabIndex="102" UseSubmitBehavior="false" Text="Cancel" Width="130px" OnClick="btnCancel_Click" />
                <br /><br />


            </ContentTemplate>
        </asp:UpdatePanel>
    </telerik:RadCodeBlock>
</asp:Content>


